#!/bin/bash

# set -e - 遇到错误立即退出
# set -u - 使用未定义的变量时报错
# set -x - 显示执行的命令（调试用）
# set -o pipefail - 管道中任何命令失败都返回失败
set -e

# 设置私钥权限
chmod 600 ${SSH_IDENTITY}

sshServer="${SSH_USER_NAME}@${REMOTE_HOST}"
echo "远端服务器: ${sshServer}:${REMOTE_APP_PATH}"

echo "确保远程目录存在"

# -o StrictHostKeyChecking=no：关闭严格的主机密钥检查。
#   第一次连接或目标主机的 SSH 指纹有变化时，默认会提示用户确认。这个选项会直接接受而不提示。
# -o UserKnownHostsFile=/dev/null：把已知主机列表指向 /dev/null
#  （即不使用/不更新默认的 ~/.ssh/known_hosts），避免脚本修改 Jenkins 主机上的 known_hosts 文件，也防止因里面有旧指纹而报错。

# 确保远程目录存在
ssh -i ${SSH_IDENTITY} \
    -o StrictHostKeyChecking=no \
    -o UserKnownHostsFile=/dev/null \
    -p ${REMOTE_PORT} \
    ${sshServer} \
    "mkdir -p ${REMOTE_APP_PATH}"

echo "使用 scp 上传文件"
# 使用 scp 上传文件
scp -i ${SSH_IDENTITY} \
    -o StrictHostKeyChecking=no \
    -o UserKnownHostsFile=/dev/null \
    -P ${REMOTE_PORT} \
    ${TAR_FILE} \
    ${sshServer}:${REMOTE_APP_PATH}/

echo "文件上传成功"

