#!/bin/bash

# set -e - 遇到错误立即退出
# set -u - 使用未定义的变量时报错
# set -x - 显示执行的命令（调试用）
# set -o pipefail - 管道中任何命令失败都返回失败
set -e

# # config 目录,是基于当前 Jenkinsfile 的相对目录
# # 检查并复制配置文件
# if [ -d "./${CONFIG_DIR}" ] && [ -n "$(ls -A ./${CONFIG_DIR}/*.* 2>/dev/null)" ]; then
#     cp -f ./${CONFIG_DIR}/*.* ./${GIT_DIR}/src/main/resources
#     echo "配置文件已复制"
# else
#     echo "WARNING: ${CONFIG_DIR} 目录不存在或为空，跳过配置文件复制"
# fi

# 使用 Maven 容器编译 Java 代码
# $$ 在 shell（bash/sh）里代表“当前进程的 PID”
# 确保唯一性,便于追踪容器
CONTAINER_NAME="build-${PROJECT_NAME}-${BUILD_ENV}-$$"

cleanup_container() {
    docker rm -f "${CONTAINER_NAME}" >/dev/null 2>&1 || true
}
# 注册清理函数，脚本结束或中断时都会执行
trap cleanup_container EXIT

# 获取 Jenkins 用户身份,编译完成后,再修改权限，避免 root 权限文件。
HOST_UID="$(id -u)"
HOST_GID="$(id -g)"

docker run --rm \
    --name "${CONTAINER_NAME}" \
    -e HOST_UID=${HOST_UID} \
    -e HOST_GID=${HOST_GID} \
    -v "$(pwd)/${GIT_DIR}:/workspace" \
    -w /workspace \
    -e BUILD_ENV=${BUILD_ENV} \
    -e BUILD_DIR=${BUILD_DIR} \
    ${DOCKER_IMG} \
    bash -c "
        # 设置失败就停止
        set -euo pipefail
        # 设置编译状态
        build_status=fail
        cleanup() {
            # 如果编译失败,则删除编译目录
            if [ \"\${build_status}\" != \"success\" ]; then
                echo \"build failed, clean ${BUILD_DIR}\"
                rm -rf \"./${BUILD_DIR}\" || true
            fi
        }
        trap cleanup EXIT
        MVN_CMD=\"mvn clean package -DskipTests\"
        if [ -n \"${BUILD_ENV}\" ]; then
            MVN_CMD=\"\${MVN_CMD} -P${BUILD_ENV} -Dbuild.env=${BUILD_ENV}\"
        fi
        \${MVN_CMD} &&
        chown -R \"${HOST_UID}:${HOST_GID}\" \"${BUILD_DIR}\" &&
        build_status=success
    "
# 检查编译是否成功
jarFile="${BUILD_TARGET_DIR}/${BUILD_FILE}"
echo "检查编译是否成功 ${jarFile}"
if [ ! -f "${jarFile}" ]; then
    echo "ERROR: 编译失败，未找到 ${jarFile}"
    exit 1
fi
echo "编译成功: ${jarFile}"

